<?php
/**
 * BLINDAGEM DEFINITIVA DE MEMÓRIA E PERFORMANCE DE BUSCA
 */
ob_start();

if (session_status() === PHP_SESSION_NONE) {
    session_start();
}
session_write_close();

ini_set('memory_limit', '512M');
error_reporting(0);

include "session.php";

$userAgent = 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) IPTV_WebPlayer/3.0_Optimized';

function makeApiCall($url, $userAgent) {
    $ch = curl_init();
    curl_setopt_array($ch, [
        CURLOPT_URL => $url,
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_USERAGENT => $userAgent,
        CURLOPT_SSL_VERIFYPEER => false,
        CURLOPT_ENCODING => "gzip, deflate",
        CURLOPT_CONNECTTIMEOUT => 5,
        CURLOPT_TIMEOUT => 30,
        CURLOPT_IPRESOLVE => CURL_IPRESOLVE_V4 
    ]);

    $response = curl_exec($ch);
    $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    curl_close($ch);
    
    if ($httpCode === 200 && !empty($response)) {
        $data = json_decode($response, true);
        unset($response);
        return is_array($data) ? $data : [];
    }
    return [];
}

function searchContent($search_query, $username, $password, $get_dns, $userAgent) {
    $movie_results = []; 
    $series_results = [];
    $search_query = mb_strtolower($search_query, 'UTF-8');
    
    $url_movies = $get_dns . "/player_api.php?username=" . urlencode($username) . "&password=" . urlencode($password) . "&action=get_vod_streams";
    $movies_api = makeApiCall($url_movies, $userAgent);

    if(!empty($movies_api)){
        foreach ($movies_api as $key => $movie) {
            $name = $movie['name'] ?? '';
            if (stripos($name, $search_query) !== false) {
                $movie_results[] = [
                    'title' => htmlspecialchars($name),
                    'id' => htmlspecialchars($movie['stream_id']),
                    'poster' => (!empty($movie['stream_icon']) && filter_var($movie['stream_icon'], FILTER_VALIDATE_URL)) ? $movie['stream_icon'] : "https://i.imgur.com/Mn7aXQD.jpg"
                ];
            }
            unset($movies_api[$key]);
        }
        $movies_api = null;
    }

    $url_series = $get_dns . "/player_api.php?username=" . urlencode($username) . "&password=" . urlencode($password) . "&action=get_series";
    $series_api = makeApiCall($url_series, $userAgent);

    if(!empty($series_api)){
        foreach ($series_api as $key => $series) {
            $name = $series['name'] ?? '';
            if (stripos($name, $search_query) !== false) {
                $series_results[] = [
                    'title' => htmlspecialchars($name),
                    'id' => htmlspecialchars($series['series_id']),
                    'poster' => (!empty($series['cover']) && filter_var($series['cover'], FILTER_VALIDATE_URL)) ? $series['cover'] : "https://i.imgur.com/Mn7aXQD.jpg"
                ];
            }
            unset($series_api[$key]);
        }
        $series_api = null;
    }
    
    gc_collect_cycles();
    return ['movies' => $movie_results, 'series' => $series_results];
}

$search_query = ''; 
$search_results = [];
if (isset($_GET['q']) && !empty(trim($_GET['q']))) {
    $search_query = htmlspecialchars($_GET['q']);
    $search_results = searchContent($search_query, $username, $password, $get_dns, $userAgent);
}
?>

<!DOCTYPE html>
<html lang="pt-br">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no">
    <title>WEB PLAYER</title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css">
    <style>
        :root {
            --header-bg: #1a2233;
            --accent: #00ffe7; /* Ciano Neon */
            --cta: #ff0057;
            --radius: 15px;
            --glass: rgba(255, 255, 255, 0.08);
            --transition: cubic-bezier(0.4, 0, 0.2, 1);
        }

        body {
            background: #0f172a; color: #fff; font-family: 'Segoe UI', Roboto, sans-serif; margin: 0;
            overflow-x: hidden; -webkit-tap-highlight-color: transparent;
        }

        .navbar {
            position: sticky; top: 0; width: 100%; height: 70px;
            background: var(--header-bg); border-bottom: 1px solid rgba(255,255,255,0.05);
            display: flex; align-items: center; justify-content: space-between;
            padding: 0 5%; z-index: 1000; box-sizing: border-box;
            box-shadow: 0 4px 30px rgba(0, 0, 0, 0.5);
        }

        .logo img { height: 35px; width: auto; filter: drop-shadow(0 0 5px rgba(0,255,231,0.2)); }

        .nav-links { display: flex; gap: 10px; }
        .nav-links a {
            color: #94a3b8; text-decoration: none; font-size: 0.8rem; font-weight: 600;
            padding: 8px 12px; border-radius: 10px; transition: 0.3s;
            display: flex; align-items: center; gap: 8px; text-transform: uppercase;
        }
        .nav-links a:hover { background: var(--glass); color: var(--accent); }

        .right-controls { display: flex; align-items: center; gap: 15px; }

        /* BUSCA PREMIUM */
        .search-area {
            display: flex; align-items: center; position: relative;
            background: rgba(255,255,255,0.05);
            padding: 5px; border-radius: 30px;
            transition: all 0.4s var(--transition);
            border: 1px solid transparent;
        }
        .search-area.active {
            background: rgba(0,0,0,0.4);
            border-color: var(--accent);
            box-shadow: 0 0 15px rgba(0, 255, 231, 0.2);
        }

        .search-container {
            width: 0; overflow: hidden; transition: width 0.4s var(--transition);
        }
        .search-area.active .search-container { width: 250px; }
        
        .search-container input {
            background: transparent; border: none; color: #fff; padding: 8px 15px;
            width: 100%; outline: none; font-size: 0.9rem;
        }

        .search-btn-trigger {
            background: none; border: none; color: #fff; font-size: 1.1rem;
            cursor: pointer; width: 35px; height: 35px; border-radius: 50%;
            display: flex; align-items: center; justify-content: center;
            transition: 0.3s;
        }
        .search-area.active .search-btn-trigger { color: var(--accent); }

        /* GRID RESULTADOS */
        .main-content { padding-top: 20px; }
        .search-results {
            display: grid;
            grid-template-columns: repeat(auto-fill, minmax(160px, 1fr));
            gap: 20px; padding: 20px 5%;
        }

        .result-item {
            background: rgba(30, 41, 59, 0.5); border-radius: var(--radius); overflow: hidden;
            text-decoration: none; color: #fff; transition: all 0.3s var(--transition);
            border: 1px solid rgba(255,255,255,0.03); position: relative;
        }
        .result-item:hover { transform: translateY(-5px); border-color: var(--accent); box-shadow: 0 10px 20px rgba(0,0,0,0.4); }
        .result-item img { width: 100%; aspect-ratio: 2/3; object-fit: cover; }
        .result-item p { padding: 12px; margin: 0; font-size: 0.85rem; font-weight: 500; text-align: center; }

        /* MOBILE FIX */
        @media (max-width: 768px) {
            .nav-links { display: none; }
            .search-area.active .search-container { width: 150px; }
            .search-results { grid-template-columns: repeat(3, 1fr); gap: 10px; }
            
            .mobile-nav {
                display: flex; position: fixed; bottom: 0; left: 0; right: 0;
                background: rgba(15, 23, 42, 0.95); backdrop-filter: blur(15px);
                height: 65px; justify-content: space-around; align-items: center;
                border-top: 1px solid rgba(255,255,255,0.1); z-index: 10000;
            }
            .nav-item { flex:1; display:flex; flex-direction:column; align-items:center; color:#64748b; text-decoration:none; font-size:0.6rem; }
            .nav-item i { font-size: 1.2rem; margin-bottom: 4px; }
            .nav-item.active { color: var(--accent); }
            body { padding-bottom: 75px; }
        }

        @media (max-width: 480px) {
            .search-results { grid-template-columns: repeat(2, 1fr); }
        }
        
        /* Esconde no PC */
.mobile-nav {
    display: none;
}
    </style>
</head>
<body>

<nav class="navbar">
    <div class="logo">
        <a href="homex.php"><img src="img/sTREAMING (3) (1).png" alt="Logo"></a>
    </div>

   <div class="nav-links">
    <a href="homex.php"><i class="fas fa-th-large"></i> INICIO</a>
    <a href="tvguide.php"><i class="fas fa-satellite-dish"></i> CANAIS</a>
    <a href="moviesondemand.php"><i class="fas fa-play-circle"></i> FILMES</a>
    <a href="seriesondemand.php"><i class="fas fa-clapperboard"></i> SÉRIES</a>
    <a href="myaccount.php"><i class="fas fa-user-circle"></i> CONTA</a>
    <a href="settings.php"><i class="fas fa-sliders-h"></i> FLUXO</a>
    <a href="logout.php"><i class="fas fa-power-off"></i> SAIR</a>
</div>

    <div class="right-controls">
        <form action="" method="GET" id="search-form">
            <div class="search-area <?= !empty($search_query) ? 'active' : '' ?>" id="search-wrapper">
                <div class="search-container">
                    <input type="text" name="q" id="search-input" placeholder="O que vamos assistir?" value="<?= $search_query ?>" autocomplete="off">
                </div>
                <button type="button" class="search-btn-trigger" id="search-trigger">
                    <i class="fas fa-search"></i>
                </button>
            </div>
        </form>
        <img src="https://i.pravatar.cc/100?u=<?= $username ?>" style="width:35px; height:35px; border-radius:50%; border:2px solid var(--accent); cursor:pointer" onclick="location.href='myaccount.php'">
    </div>
</nav>

<div class="main-content">
    <?php if (!empty($search_query)): ?>
        <h3 style="text-align:center; font-weight:300; margin: 30px 0;">Mostrando resultados para <b style="color:var(--accent)">"<?= $search_query ?>"</b></h3>
        
        <?php 
        $found = false;
        foreach (['movies' => 'Filmes', 'series' => 'Séries'] as $key => $title): 
            if (!empty($search_results[$key])): 
                $found = true;
        ?>
            <div style="max-width:1400px; margin:auto;">
                <h4 style="margin: 20px 5%; border-left: 4px solid var(--accent); padding-left: 15px; text-transform:uppercase; letter-spacing:1px;"><?= $title ?></h4>
                <div class="search-results">
                    <?php foreach ($search_results[$key] as $item): ?>
                        <a href="<?= ($key == 'movies' ? 'Movie_description.php' : 'seriesvideo.php') ?>?id=<?= $item['id'] ?>" class="result-item">
                            <img src="<?= $item['poster'] ?>" alt="poster" loading="lazy">
                            <p><?= $item['title'] ?></p>
                        </a>
                    <?php endforeach; ?>
                </div>
            </div>
        <?php endif; endforeach; ?>

        <?php if(!$found): ?>
            <div style="text-align:center; margin-top:100px; opacity:0.3;">
                <i class="fas fa-search-minus" style="font-size:4rem; margin-bottom:20px;"></i>
                <p style="font-size:1.2rem;">Ops! Não encontramos nada.</p>
            </div>
        <?php endif; ?>
    <?php endif; ?>
</div>

<nav class="mobile-nav">
    <a href="homex.php" class="nav-item">
        <i class="fas fa-home"></i>
        <span>Início</span>
    </a>
    <a href="tvguide.php" class="nav-item">
        <i class="fas fa-broadcast-tower"></i>
        <span>TV</span>
    </a>
    <a href="moviesondemand.php" class="nav-item">
        <i class="fas fa-film"></i>
        <span>Filmes</span>
    </a>
    <a href="seriesondemand.php" class="nav-item">
        <i class="fas fa-tv"></i>
        <span>Séries</span>
    </a>
    <a href="myaccount.php" class="nav-item">
        <i class="fas fa-user"></i>
        <span>Conta</span>
        </a>
    <a href="settings.php" class="nav-item">
        <i class="fas fa-meteor"></i>
        <span>FLUXO</span>
    </a>
    <a href="logout.php" class="nav-item logout">
        <i class="fas fa-sign-out-alt"></i>
        <span>Sair</span>
    </a>
</nav>




<script>
    const wrapper = document.getElementById('search-wrapper');
    const trigger = document.getElementById('search-trigger');
    const input = document.getElementById('search-input');
    const form = document.getElementById('search-form');

    trigger.addEventListener('click', (e) => {
        if (!wrapper.classList.contains('active')) {
            // Se estiver fechado, abre e foca no input
            wrapper.classList.add('active');
            input.focus();
        } else {
            // Se estiver aberto
            if (input.value.trim() !== "") {
                // Se tiver texto, envia o formulário
                form.submit();
            } else {
                // Se estiver vazio, fecha
                wrapper.classList.remove('active');
            }
        }
    });

    // Detecta o "Enter" no teclado
    input.addEventListener('keypress', (e) => {
        if (e.key === 'Enter') {
            if (input.value.trim() !== "") {
                form.submit();
            } else {
                e.preventDefault();
                wrapper.classList.remove('active');
            }
        }
    });

    // Fecha ao clicar fora se estiver vazio
    document.addEventListener('click', (e) => {
        if (!wrapper.contains(e.target) && input.value.trim() === "") {
            wrapper.classList.remove('active');
        }
    });
</script>

</body>
</html>
<?php ob_end_flush(); ?>